# tests app_sirene_operator

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse


from app_home.home import cavaliba_update
from app_home.configuration import get_configuration


from app_user.models import SireneUser, SireneGroup
from app_user.group import group_get_by_name
from app_user.role import role_get_by_name


# --------------------------------------------------
# Sirene Operator 
# --------------------------------------------------
class AppSireneOperatorTest(TestCase):

    @classmethod
    def setUpTestData(cls):
        cavaliba_update(verbose=False)

        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_sirene_operator")
        role.users.add(user)
        role.save()


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_auth_mode_and_role(self):
        r = get_configuration("env", "CAVALIBA_AUTH_MODE")
        self.assertEqual(r, 'unittest')


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_private(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_history(self):
        response = self.client.get(reverse('app_sirene:history'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_message_editor(self):
        response = self.client.get(reverse('app_sirene:message_editor'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_smsjournal(self):
        response = self.client.get(reverse('app_sirene:sms_journal'))
        self.assertEqual(response.status_code, 200)


# -- TEMPLATE
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_template_selector(self):
        response = self.client.get(reverse('app_sirene:template_selector'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_template_list(self):
        response = self.client.get(reverse('app_sirene:template_list'))
        self.assertEqual(response.status_code, 200)

    # can read (200) form, but not submit
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_template_edit(self):
        response = self.client.get(reverse('app_sirene:template_edit'))
        self.assertEqual(response.status_code, 200)


# -- flush all GET/POST
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_get(self):
        response = self.client.get(reverse('app_sirene:flushall'), follow=True)
        #self.assertEqual(response.status_code, 302)
        a = ('/sirene/', 302)
        #print(response.redirect_chain)
        self.assertTrue( a in response.redirect_chain)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_post(self):
        response = self.client.post(reverse('app_sirene:flushall'), follow=True)
        a = ('/sirene/private/', 302)
        #print(response.redirect_chain)
        self.assertTrue( a in response.redirect_chain)


# -- CATEGORY

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_auth_allperm_category_list(self):
        response = self.client.get(reverse('app_sirene:category_list'))
        self.assertEqual(response.status_code, 200)
    
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_auth_allperm_category_edit(self):
        response = self.client.get(reverse('app_sirene:category_edit'))
        self.assertEqual(response.status_code, 200)

