
from .field import Field

# -------------
# FLOAT
# -------------
class FieldFloat(Field):


    def get_datapoint_ui_detail(self):
        datapoint = super().get_datapoint_ui_detail()
        a = [str(i) for i in self.value]
        datapoint["value"] = ' '.join(a)
        return datapoint

    def get_datapoint_ui_edit(self):
        datapoint = super().get_datapoint_ui_edit()
        # force to string and separate multi value with space
        a = [str(i) for i in self.value]
        datapoint["value"] = ' '.join(a)
        return datapoint

    def merge_edit_data(self, data):
        ''' data is a list of string ["3.2 5.4", ...]'''
        self.value = []
        try:
            values = data[0].split()
        except:
            return
        for i in values:
            try:
                self.value.append(float(i))
            except:
                pass

    def merge_new_data(self, data):
        ''' data is a list of string ["3.2 5.4", ...] ; first item is useful only'''
        self.value = []
        try:
            values = data[0].split()
        except:
            return
        for i in values:
            try:
                self.value.append(float(i))
            except:
                pass


    def is_valid(self):
        r = super().is_valid()
        for v in self.value:
            if type(v) is str:
                if len(v) == 0:
                    continue            
            try:
                float(v)
            except:
                return False
        return r
