# test_app_user 
# (c) cavaliba.com

import yaml 

from django.test import TestCase
from django.urls import reverse

from app_home.home import cavaliba_init
from app_data.data import Instance



class APIKeyTest(TestCase):

    @classmethod
    def setUpTestData(cls):
    #def setUp(self):
        cavaliba_init(verbose=False)


    def test_auth_nokey(self):
        # no key 
        response = self.client.get(reverse('app_data:api_index'))
        self.assertEqual(response.status_code, 401)



    def test_auth_goodkey(self):
        # key OK
        instance = Instance(classname="_apikey", iname="goodkro")
        data = {
            "keyvalue":"ktest",
            "ip_filter":"*",
            "is_readonly":True,
            "is_enabled":True,
        }
        instance.merge_import_data(data)
        instance.create()

        response = self.client.get(
            reverse('app_data:api_index'),
            headers = {"X-Cavaliba-Key":"goodkro ktest"},
            )
        self.assertEqual(response.status_code, 200)



    def test_auth_keyoff(self):
        # key OFF
        instance = Instance(classname="_apikey", iname="koff")
        data = {
            "keyvalue":"ktest",
            "ip_filter":"*",
            "is_readonly":False,
            "is_enabled":False,
        }
        instance.merge_import_data(data)
        instance.create()

        response = self.client.get(
            reverse('app_data:api_index'),
            headers = {"X-Cavaliba-Key":"koff ktest"},
            )
        self.assertEqual(response.status_code, 401)


    def test_auth_badpwd(self):
        # Bad PWD

        instance = Instance(classname="_apikey", iname="kro")
        data = {
            "keyvalue":"ktest",
            "ip_filter":"*",
            "is_readonly":True,
            "is_enabled":True,
        }
        instance.merge_import_data(data)
        instance.create()

        response = self.client.get(
            reverse('app_data:api_index'),
            headers = {"X-Cavaliba-Key":"kro badkv"},
            )
        self.assertEqual(response.status_code, 401)



    def test_auth_ro_ko(self):

        # RO / RW
        instance = Instance(classname="_apikey", iname="kro")
        data = {
            "keyvalue":"ktest",
            "ip_filter":"*",
            "is_readonly":True,
            "is_enabled":True,
        }
        instance.merge_import_data(data)
        instance.create()        
        response = self.client.post(
            reverse('app_data:api_index'),
            headers = {"X-Cavaliba-Key":"kro ktest"},
            )
        self.assertEqual(response.status_code, 401)

    def test_auth_rw_ok(self):

        # key RW
        instance = Instance(classname="_apikey", iname="krw")
        data = {
            "keyvalue":"ktest",
            "ip_filter":"*",
            "is_readonly":False,
            "is_enabled":True,
        }
        instance.merge_import_data(data)
        instance.create()
        #         
        response = self.client.get(
            reverse('app_data:api_index'),
            headers = {"X-Cavaliba-Key":"krw ktest"},
            )
        self.assertEqual(response.status_code, 200)


